<?php
include 'config.php';

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo "Invalid Request Method";
    exit;
}

$type = isset($_POST['type']) ? $_POST['type'] : '';

if ($type === 'requestxstrong') {
    $name   = $_POST['name'] ?? '';
    $email  = $_POST['email'] ?? '';
    $method = $_POST['method'] ?? '';
    $number = $_POST['number'] ?? '';
    $amount = $_POST['amount'] ?? '';
    $trxid  = $_POST['trxid'] ?? '';
    $fcm    = $_POST['fcm'] ?? '';
    $date   = date("d-M-Y");
    $time   = date("h:i:s A");

    // basic validation
    if ($name === '' || $email === '' || $amount === '' || $trxid === '') {
        echo "Missing required fields";
        exit;
    }
    if (!is_numeric($amount) || $amount <= 0) {
        echo "Invalid amount";
        exit;
    }

    $stmt = $conn->prepare("INSERT INTO addmoney (name, email, method, number, amount, trxid, date, time, fcm, status) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, 'Pending')");
    $stmt->bind_param("ssssdssss", $name, $email, $method, $number, $amount, $trxid, $date, $time, $fcm);

    if ($stmt->execute()) {
        echo "Request Successfully";
    } else {
        echo "Error Requesting: " . $stmt->error;
    }
    $stmt->close();
    $conn->close();
    exit;
}

if ($type === 'pending') {
    $query = "SELECT * FROM addmoney WHERE status = 'Pending' ORDER BY id DESC";
    $result = mysqli_query($conn, $query);

    if ($result) {
        $data = [];
        while ($row = mysqli_fetch_assoc($result)) {
            $data[] = $row;
        }

        if (!empty($data)) {
            header('Content-Type: application/json; charset=utf-8');
            echo json_encode($data, JSON_UNESCAPED_UNICODE);
        } else {
            echo "No Unpaid Request Found";
        }
    } else {
        echo "Error Getting Unpaid Request: " . mysqli_error($conn);
    }
    $conn->close();
    exit;
}

if ($type === 'success') {
    $amount = $_POST['amount'] ?? '';
    $email  = $_POST['email'] ?? '';
    $trxid  = $_POST['trxid'] ?? '';

    if ($trxid === '' || $email === '' || $amount === '') {
        echo "Missing required fields";
        exit;
    }
    if (!is_numeric($amount) || $amount <= 0) {
        echo "Invalid amount";
        exit;
    }

    // Begin transaction to ensure atomicity
    $conn->begin_transaction();

    try {
        // 1) check addmoney row exists and is Pending (or not already Success)
        $chk = $conn->prepare("SELECT status FROM addmoney WHERE trxid = ? FOR UPDATE");
        $chk->bind_param("s", $trxid);
        $chk->execute();
        $res = $chk->get_result();

        if ($res->num_rows === 0) {
            throw new Exception("Transaction not found");
        }

        $row = $res->fetch_assoc();
        if ($row['status'] === 'Success') {
            throw new Exception("Transaction already marked Success");
        }

        // 2) update users balance
        $updUser = $conn->prepare("UPDATE users SET balance = balance + ? WHERE email = ?");
        $updUser->bind_param("ds", $amount, $email);
        if (!$updUser->execute()) {
            throw new Exception("Error updating user balance: " . $updUser->error);
        }

        // 3) update addmoney status
        $updAdd = $conn->prepare("UPDATE addmoney SET status = 'Success' WHERE trxid = ?");
        $updAdd->bind_param("s", $trxid);
        if (!$updAdd->execute()) {
            throw new Exception("Error updating addmoney status: " . $updAdd->error);
        }

        $conn->commit();
        echo "Add Money Successfully";
    } catch (Exception $e) {
        $conn->rollback();
        echo "Error Add Money: " . $e->getMessage();
    }

    $conn->close();
    exit;
}

if ($type === 'failed') {
    $trxid = $_POST['trxid'] ?? '';

    if ($trxid === '') {
        echo "Missing trxid";
        exit;
    }

    $stmt = $conn->prepare("UPDATE addmoney SET status = 'Failed' WHERE trxid = ?");
    $stmt->bind_param("s", $trxid);

    if ($stmt->execute()) {
        if ($stmt->affected_rows > 0) {
            echo "Add Money Failed Success";
        } else {
            echo "No matching transaction found or already updated";
        }
    } else {
        echo "Error Add Money: " . $stmt->error;
    }
    $stmt->close();
    $conn->close();
    exit;
}

// unknown type
echo "Invalid type";
$conn->close();
?>led
if ($type === 'failed') {
    // ensure lowercase 'id' used
    $id = isset($_POST['id']) ? intval($_POST['id']) : 0;

    if ($id <= 0) {
        echo json_encode(["error" => "Invalid id for failed"]);
        $conn->close();
        exit;
    }

    $stmt = $conn->prepare("UPDATE addmoney SET status = 'Failed' WHERE id = ?");
    if (!$stmt) {
        echo json_encode(["error" => "Prepare failed: " . $conn->error]);
        $conn->close();
        exit;
    }
    $stmt->bind_param("i", $id);

    if ($stmt->execute()) {
        echo json_encode(["message" => "Add Money Failed Success"]);
    } else {
        echo json_encode(["error" => "Error Add Money: " . $stmt->error]);
    }

    $stmt->close();
    $conn->close();
    exit;
}

// If none matched
echo json_encode(["error" => "Invalid request type"]);
$conn->close();
?>